; THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
; REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY, 
; INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS 
; FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR 
; COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. 
; TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET 
; POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY 
; INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR 
; YOUR USE OF THE PROGRAM.
;
; IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, 
; CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY 
; THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED 
; OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT 
; OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM. 
; EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF 
; REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS 
; OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF 
; USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S 
; AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF 
; YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS 
; (U.S.$500).
;
; Unless otherwise stated, the Program written and copyrighted 
; by Texas Instruments is distributed as "freeware".  You may, 
; only under TI's copyright in the Program, use and modify the 
; Program without any charge or restriction.  You may 
; distribute to third parties, provided that you transfer a 
; copy of this license to the third party and the third party 
; agrees to these terms by its first use of the Program. You 
; must reproduce the copyright notice and any other legend of 
; ownership on each copy or partial copy, of the Program.
;
; You acknowledge and agree that the Program contains 
; copyrighted material, trade secrets and other TI proprietary 
; information and is protected by copyright laws, 
; international copyright treaties, and trade secret laws, as 
; well as other intellectual property laws.  To protect TI's 
; rights in the Program, you agree not to decompile, reverse 
; engineer, disassemble or otherwise translate any object code 
; versions of the Program to a human-readable form.  You agree 
; that in no event will you alter, remove or destroy any 
; copyright notice included in the Program.  TI reserves all 
; rights not specifically granted under this license. Except 
; as specifically provided herein, nothing in this agreement 
; shall be construed as conferring by implication, estoppel, 
; or otherwise, upon you, any license or other right under any 
; TI patents, copyrights or trade secrets.
;
; You may not use the Program in non-TI devices.



; *****************************************************************************
; File:     "SDQ_writeByte_CCS.asm"
; Author:   Randy Wu, Texas Instruments
; Date:     November 2009
; 
; Assembly routine to transmit 1 whole byte via SDQ protocol
;
; *****************************************************************************

 .cdecls C,LIST,    "MSP430_SDQLIB.h"

;-------------------------------------------------------------------------------
            ;RSEG     DATA16_N                   ; Place variables in RAM
            ;EVEN                                ; Ensure its on an even boundary
            .align 2
;-------------------------------------------------------------------------------
;DelayTarget DS      2
            .bss DelayTarget, 2
;============================================================================
; DLYUSEC_07A
;
; Registers Used : None
;============================================================================

            ;PUBLIC  DLYUSEC_07A             ; Declare symbol to be exported
            ;RSEG    CODE                    ; Code is relocatable
            .def  DLYUSEC_07A                ; Declare symbol to be exported
            .text                            ; Code is relocatable
        
DLYUSEC_07A;
            push.w  &TAR                    ; Get current Timer_A value
            add.w   #(tUSEC*7),0(SP)        ; (Do calc on TOS)
            pop.w   &DelayTarget            ; Timer_A value to stop delay
DUSEC_07A   cmp     &TAR,&DelayTarget       ; dst >= src ?
            jge     DUSEC_07A               ; Jump if dst >= src
            ret
            
;============================================================================
; DLYUSEC_65A
;
; Registers Used : None
;============================================================================

            ;PUBLIC  DLYUSEC_65A             ; Declare symbol to be exported
            ;RSEG    CODE                    ; Code is relocatable
            .def  DLYUSEC_65A                ; Declare symbol to be exported
            .text                            ; Code is relocatable
        
DLYUSEC_65A;
            push.w  &TAR                    ; Get current Timer_A value
            add.w   #(tUSEC*65),0(SP)       ; (Do calc on TOS)
            pop.w   &DelayTarget            ; Timer_A value to stop delay
DUSEC_65A   cmp     &TAR,&DelayTarget       ; dst >= src ?
            jge     DUSEC_65A               ; Jump if dst >= src
            ret
            
;============================================================================
; DLYUSEC_07 (@ 8 MHz MCLK)
;
; Registers Used : R11 = loop counter
;============================================================================

            ;PUBLIC  DLYUSEC_07             ; Declare symbol to be exported
            ;RSEG    CODE                    ; Code is relocatable
            .def  DLYUSEC_07                 ; Declare symbol to be exported
            .text                            ; Code is relocatable
        
DLYUSEC_07;
            push    R11                     ; Save R11
            mov     #6,R11                  ; Initialize loop counter
DS07D       dec     R11
            jeq     DS07E                   ; If counter = 0, we're done
            nop                             ; Do nothing
            jmp     DS07D                   ; Decrement & check counter
DS07E       pop     R11                     ; Restore R11
            ret                             ; Return from subroutine
        
;============================================================================
; DLYUSEC_65 (@ 8 MHz MCLK)
;
; Registers Used : R11 = loop counter
;============================================================================

            ;PUBLIC  DLYUSEC_65              ; Declare symbol to be exported
            ;RSEG    CODE                    ; Code is relocatable
            .def  DLYUSEC_65                 ; Declare symbol to be exported
            .text                            ; Code is relocatable
        
DLYUSEC_65;
            push    R11                     ; Save R11
            mov     #83,R11                 ; Initialize loop counter
DS65D       dec     R11
            jeq     DS65E                   ; If counter = 0, we're done
            nop                             ; Do nothing
            jmp     DS65D                   ; Decrement & check counter
DS65E       pop     R11                     ; Restore R11
            ret                             ; Return from subroutine
        
;============================================================================
; SDQ_writeByte
;
; Registers Used : R6  = transmit bit counter
;                  R12 = 8-bit byte to transmit
;                  
;============================================================================

            ;PUBLIC  SDQ_writeByte           ; Declare symbol to be exported
            ;RSEG    CODE                    ; Code is relocatable
            .def  SDQ_writeByte              ; Declare symbol to be exported
            .text                            ; Code is relocatable
        
SDQ_writeByte;
            dint                            ; Disable global interrupts
            push    SR                      ; Save Status Register
            push    R6                      ; Save R6
            mov     #09h,R6                 ; Initialize bit counter
SDQTD       dec     R6
            jeq     TBEND                   ; If counter = 0, we're done
TX_BIT      bis.b   #P1_SDQ,&P1OUT          ; Pull SDQ bus to HIGH state          
            bis.b   #P1_SDQ,&P1DIR          ; Set SDQ as OUTPUT direction          
            bic.b   #P1_SDQ,&P1OUT          ; Pull SDQ bus to LOW state
            rra     R12                     ; LSB is shifted into CARRY bit
            jc      TX_1                    ; Jump if bit = 1
TX_0        call    #DLYUSEC_65             ; Delay 65 usec
            bis.b   #P1_SDQ,&P1OUT          ; Pull SDQ HIGH   
            call    #DLYUSEC_07             ; Delay 7 usec
            jmp     TREC                    ; Delay for recovery period
TX_1        call    #DLYUSEC_07             ; Delay 7 usec
            bis.b   #P1_SDQ,&P1OUT          ; Pull SDQ HIGH
            call    #DLYUSEC_65             ; Delay 65 usec
TREC        call    #DLYUSEC_07             ; Delay 7 usec
            jmp     SDQTD                   ; Decrement bit counter
TBEND       call    #DLYUSEC_65             ; Delay 65 usec
            pop     R6                      ; Restore R6
            pop     SR                      ; Restore Status Register
            eint
            ret                             ; Return from subroutine
        
            ;END
            .end
